/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.mocmulti.BinaryDump;
import cds.mocmulti.MocItem;
import cds.mocmulti.Unite;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MultiMoc
implements Iterable<MocItem> {
    static final boolean DEBUG = true;
    public static String KEY_ID = "ID";
    public static String KEY_TIMESTAMP = "TIMESTAMP";
    public static String KEY_REMOVE = "MOCSERVER_REMOVE";
    public static final int OVERLAPS = 0;
    public static final int ENCLOSED = 1;
    public static final int COVERS = 2;
    public static final String[] INTERSECT = new String[]{"overlaps", "enclosed", "covers"};
    private final String COORDSYS = "C";
    protected HashMap<String, MocItem> map = new HashMap(30000);
    protected int mocOrder = -1;
    private ArrayList<MyProperties> except = null;
    private MyProperties example = null;
    private int nbConvertFromGtoC = 0;
    private int nbReduceMem;
    private static Healpix hpx = new Healpix();
    private long lastGc = 0L;
    private static final boolean DEBUGMATCH = false;

    public static MultiMoc createFromDump(String binaryDumpFile) throws Exception {
        BinaryDump dump = new BinaryDump();
        return dump.load(binaryDumpFile);
    }

    public void add(String mocId, Moc moc, MyProperties prop, long dateMoc, long dateProp) throws Exception {
        MocItem mi = new MocItem(mocId, moc, prop, dateMoc, dateProp);
        this.add(mi);
    }

    public void add(MyProperties prop) throws Exception {
        String id = MultiMoc.getID(prop);
        MocItem mi = new MocItem(id, prop);
        this.add(mi);
    }

    public void remove(String mocId) {
        MocItem mi = this.map.get(mocId);
        if (mi == null) {
            return;
        }
        this.map.remove(mocId);
    }

    public void add(MocItem mi) {
        this.map.put(mi.mocId, mi);
    }

    public MocItem getItem(String mocId) {
        return this.map.get(mocId);
    }

    public Moc getMoc(String mocId) {
        MocItem mi = this.map.get(mocId);
        return mi == null ? null : mi.moc;
    }

    public MyProperties getProperties(String mocId) {
        MocItem mi = this.map.get(mocId);
        return mi == null ? null : mi.prop;
    }

    public MyProperties getProperties() {
        MyProperties prop = new MyProperties();
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (MocItem mi : this) {
            if (mi.prop == null) continue;
            for (String k : mi.prop.getKeys()) {
                int i;
                Integer a = (Integer)count.get(k);
                if (a == null) {
                    a = 0;
                }
                count.put(k, a + 1);
                if (this.isNumSuffix(k) || prop.get(k) != null) continue;
                String s = mi.prop.get(k);
                if (s == null) {
                    s = "null for " + mi.mocId;
                }
                if ((i = s.indexOf(9)) >= 0) {
                    s = s.substring(0, i);
                }
                if (s.length() >= 70) {
                    s = s.substring(0, 67) + "...";
                }
                prop.put(k, "ex: " + s);
            }
        }
        for (String k : prop.getKeys()) {
            if (this.isNumSuffix(k)) continue;
            String v = prop.get(k);
            Integer a = (Integer)count.get(k);
            String suffixUsage = this.suffixCounts(count, k);
            v = "(" + a + "x" + suffixUsage + ") " + v;
            prop.replaceValue(k, v);
        }
        return prop;
    }

    private boolean isNumSuffix(String s) {
        int i = s.lastIndexOf(95);
        if (i < 0) {
            return false;
        }
        try {
            Integer.parseInt(s.substring(i + 1));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String suffixCounts(HashMap<String, Integer> count, String k) {
        String kSuf;
        if (!this.isNumSuffix(k + "_1")) {
            return "";
        }
        int max = 5;
        StringBuilder rep = null;
        Integer a = null;
        int i = 0;
        while (true) {
            if ((a = count.get(kSuf = k + "_" + i)) == null) {
                if (i > 0) {
                    break;
                }
            } else if (i < max) {
                if (rep == null) {
                    rep = new StringBuilder(" [+_");
                } else {
                    rep.append(" _");
                }
                rep.append(i + ":" + a);
            }
            ++i;
        }
        if (rep != null) {
            if (i >= max) {
                kSuf = k + "_" + (i - 1);
                a = count.get(kSuf);
                rep.append(" ... _" + (i - 1));
                if (a != null) {
                    rep.append(":" + a);
                }
            }
            rep.append("]");
        }
        return rep == null ? "" : rep.toString();
    }

    public void clear() {
        this.map.clear();
    }

    public String adjustProp(MyProperties prop, String id, Moc moc) {
        String mocId;
        block18: {
            mocId = MultiMoc.getID(prop, id);
            prop.insert(KEY_ID, mocId);
            if (moc != null) {
                String mocType = moc instanceof STMoc ? "stmoc" : (moc instanceof TMoc ? "tmoc" : "smoc");
                prop.replaceValue("moc_type", mocType);
                if (moc.isTime()) {
                    prop.replaceValue("moc_time_order", moc.getTimeOrder() + "");
                    prop.replaceValue("moc_time_range", moc.getNbRanges() + "");
                }
                if (moc.isSpace()) {
                    try {
                        SMoc m = moc.getSpaceMoc();
                        prop.replaceValue("moc_sky_fraction", Unite.myRound(m.getCoverage()) + "");
                        String s = moc.getProperty("MOCORDER");
                        if (s == null) {
                            s = moc.getProperty("MOCORD_S");
                        }
                        if (s == null || s.equals("29") || s.equals("0") || s.equals("-1")) {
                            String s1;
                            int maxOrder = m.getDeepestOrder();
                            s = maxOrder == 0 ? ((s1 = prop.get("hips_order")) != null ? s1 : "10") : maxOrder + "";
                        }
                        prop.replaceValue("moc_order", s);
                        String ra = prop.get("obs_initial_ra");
                        String dec = prop.get("obs_initial_dec");
                        String fov = prop.get("obs_initial_fov");
                        if (ra == null || dec == null) {
                            ra = prop.get("hips_initial_ra");
                            dec = prop.get("hips_initial_dec");
                        }
                        if (ra != null && dec != null && fov != null) break block18;
                        if (fov == null) {
                            try {
                                int n = Integer.parseInt(prop.get("moc_order"));
                                SMoc mm = new SMoc();
                                mm.setMocOrder(n);
                                fov = mm.getAngularRes() + "";
                            }
                            catch (Exception e) {
                                fov = m.getAngularRes() + "";
                            }
                        }
                        if (ra == null || dec == null) {
                            if (m.isFull()) {
                                ra = "0";
                                dec = "+0";
                            } else {
                                try {
                                    int order = m.getMocOrder();
                                    long pix = m.valIterator().next();
                                    double[] coo = hpx.pix2ang(order, pix);
                                    ra = coo[0] + "";
                                    dec = coo[1] + "";
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (ra != null) {
                            prop.replaceValue("obs_initial_ra", ra);
                        }
                        if (dec != null) {
                            prop.replaceValue("obs_initial_dec", dec);
                        }
                        prop.replaceValue("obs_initial_fov", fov);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return mocId;
    }

    public boolean reload(String[] dirs, String exceptFile, MultiMoc oMM, boolean flagWithMoc, PrintWriter out) throws Exception {
        int nbFiles;
        try {
            this.loadException(exceptFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int originalSize = oMM == null ? 0 : oMM.map.size();
        ConcurrentLinkedQueue<File> list = new ConcurrentLinkedQueue<File>();
        long t0 = System.currentTimeMillis();
        for (String dir : dirs) {
            File f = new File(dir);
            File[] listF = f.listFiles();
            if (listF == null) continue;
            for (File f1 : listF) {
                int offset;
                String mocFile;
                String name = f1.getAbsolutePath();
                if (name.endsWith(".prop") && new File(mocFile = name.substring(0, offset = name.lastIndexOf(46)) + ".fits").exists()) continue;
                list.add(f1);
            }
        }
        int nbReaders = Runtime.getRuntime().availableProcessors() - 1;
        if (nbReaders > 10) {
            nbReaders = 10;
        }
        if (list.size() < nbReaders) {
            nbReaders = list.size();
        }
        if (nbReaders < 1) {
            nbReaders = 1;
        }
        String s = "MultiMoc loading/parsing " + list.size() + " files by " + nbReaders + " threads...\n";
        this.print(out, s);
        Reader[] reader = new Reader[nbReaders];
        HashSet<String> listId = new HashSet<String>(list.size());
        for (int i = 0; i < reader.length; ++i) {
            reader[i] = new Reader(oMM, flagWithMoc, out, list, listId);
            reader[i].start();
        }
        boolean encore = true;
        int oNbFiles = 0;
        long t1 = System.currentTimeMillis();
        while (encore) {
            nbFiles = 0;
            encore = false;
            int nth = 0;
            for (Reader r : reader) {
                if (r.running()) {
                    ++nth;
                }
                encore |= r.running();
                nbFiles += r.nbFiles;
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 5000L) {
                s = nbFiles + "... in " + Unite.getTemps(t2 - t0) + " => " + (int)(((double)nbFiles - (double)oNbFiles) / ((double)(t2 - t1) / 1000.0)) + "/s" + (nth < nbReaders ? " (" + nth + " readers running)\n" : "\n");
                this.print(out, s);
                t1 = t2;
                oNbFiles = nbFiles;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (list.size() > 0) {
            s = "Loading process not achieved (not enough RAM ?) => keep MocServer as it was before";
            this.print(out, s);
            throw new Exception(s);
        }
        nbFiles = 0;
        int nbCreation = 0;
        int nbReused = 0;
        for (Reader r : reader) {
            nbFiles += r.nbFiles;
            nbCreation += r.nbCreation;
            nbReused += r.nbReused;
        }
        double nb = nbFiles % 1000;
        long t2 = System.currentTimeMillis();
        s = nbFiles + " loaded in " + Unite.getTemps(t2 - t0) + " => avg: " + (int)(nb / ((double)(t2 - t0) / 1000.0)) + "/s\n";
        s = s + (this.nbConvertFromGtoC > 0 ? " - " + this.nbConvertFromGtoC + " moc converted from G to C" : "") + (this.nbReduceMem > 0 ? " - " + this.nbReduceMem + " moc RAM reduced" : "") + "\n";
        this.print(out, s);
        if (oMM != null) {
            s = " => " + nbCreation + " created or updated - " + nbReused + " reused as is\n";
            this.print(out, s);
        }
        this.example = null;
        return nbCreation > 0 || nbReused != originalSize;
    }

    private long getFreeMem() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMem(long more) {
        long freeMem = this.getFreeMem();
        if (freeMem > more * 5L) {
            return true;
        }
        MultiMoc multiMoc = this;
        synchronized (multiMoc) {
            freeMem = this.getFreeMem();
            if (freeMem > more * 5L) {
                return true;
            }
            long t = System.currentTimeMillis();
            if (t - this.lastGc > 1000L) {
                this.lastGc = t;
                System.gc();
                freeMem = this.getFreeMem();
                if (freeMem > more * 3L) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Reader r) throws Exception {
        File f1;
        r.nbFiles = 0;
        r.nbCreation = 0;
        r.nbReused = 0;
        String mocId = null;
        String filename = null;
        String propname = null;
        while ((f1 = r.list.poll()) != null) {
            try {
                Moc moc;
                File fprop;
                filename = f1.getAbsolutePath();
                long dateMoc = new File(filename).lastModified();
                propname = filename;
                int offset = propname.lastIndexOf(46);
                if (offset == -1) {
                    offset = propname.length();
                }
                long dateProp = !(fprop = new File(propname = propname.substring(0, offset) + ".prop")).exists() ? 0L : fprop.lastModified();
                mocId = this.getMocId(f1.getName());
                MyProperties prop = null;
                try {
                    prop = this.loadProp(propname);
                }
                catch (Exception e) {
                    this.print(r.out, "! PropError " + mocId + " [" + e.getMessage() + "] => file [" + propname + "] ignored\n");
                }
                try {
                    if (filename.endsWith(".prop")) {
                        moc = null;
                    } else {
                        if (!this.checkMem(new File(filename).length())) {
                            System.out.println("LowMemory during " + f1 + " process => stop a thread and redo");
                            r.list.add(f1);
                            return;
                        }
                        moc = null;
                        try {
                            moc = this.loadMoc(filename, prop);
                        }
                        catch (Exception e) {
                            this.print(r.out, "! MocError " + mocId + " [" + e.getMessage() + "] => file [" + filename + "] ignored\n");
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    System.out.println("OutOfMemory during " + f1 + " process => stop a thread and redo");
                    r.list.add(f1);
                    return;
                }
                if (prop == null && moc == null) continue;
                if (prop == null && moc != null) {
                    prop = new MyProperties();
                }
                if (!this.exceptProp(prop, mocId = this.adjustProp(prop, mocId, moc))) {
                    prop = null;
                    moc = null;
                }
                if (!r.flagWithMoc) {
                    moc = null;
                    dateMoc = 0L;
                }
                if (moc == null && prop == null) continue;
                MocItem mi = null;
                boolean flagCreation = true;
                MultiMoc multiMoc = this;
                synchronized (multiMoc) {
                    if (r.listId.contains(mocId)) {
                        throw new Exception("Duplicate ID");
                    }
                    r.listId.add(mocId);
                    if (r.oMM != null && (mi = r.oMM.getItem(mocId)) != null && (dateMoc == 0L || dateMoc == mi.dateMoc) && prop != null && mi.prop != null && prop.equals(mi.prop)) {
                        this.add(mi);
                        flagCreation = false;
                        ++r.nbReused;
                    }
                    if (flagCreation) {
                        this.add(mocId, moc, prop, dateMoc, dateProp);
                        ++r.nbCreation;
                    }
                }
                ++r.nbFiles;
            }
            catch (Exception e) {
                try {
                    int x = propname.lastIndexOf(46);
                    String file = propname.substring(0, x);
                    this.print(r.out, "!" + mocId + " [" + e.getMessage() + "] => files [" + file + ".xxx] ignored\n");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void print(PrintWriter out, String s) {
        if (out == null || s == null) {
            return;
        }
        if (s.startsWith("!!")) {
            s = "<font color=\"red\">" + s + "</font>";
        } else if (s.startsWith("!")) {
            s = "<font color=\"orange\">" + s + "</font>";
        } else if (s.startsWith(".")) {
            s = "<font color=\"grey\">" + s + "</font>";
        }
        out.print(s);
        out.flush();
    }

    public boolean exceptProp(MyProperties prop, String id) {
        if (this.except == null || prop == null) {
            return true;
        }
        for (MyProperties p : this.except) {
            prop.exceptions(p, id);
        }
        return prop.get(KEY_ID) == null || prop.get("MOCSERVER_REMOVE") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadException(String file) {
        if (file == null) {
            return;
        }
        ArrayList<MyProperties> p = new ArrayList<MyProperties>();
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new FileReader(file));
            MyProperties prop = null;
            while ((s = br.readLine()) != null) {
                if (s.startsWith("#")) continue;
                if (s.trim().length() == 0) {
                    if (prop == null) continue;
                    p.add(prop);
                    prop = null;
                    continue;
                }
                if (prop == null) {
                    prop = new MyProperties();
                }
                prop.add(s);
            }
            if (prop != null) {
                p.add(prop);
            }
        }
        catch (Exception e) {
            System.out.println("Exception file [" + file + "] error => " + e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        if (p.size() > 0) {
            this.except = p;
        }
    }

    public boolean isFieldName(String s) {
        if (this.example == null) {
            this.example = this.getProperties();
        }
        return this.example.get(s) != null;
    }

    public void sort() {
    }

    private String getMocId(String filename) {
        String id = filename.replace("_", "/");
        int offset = id.lastIndexOf(46);
        if (offset == -1) {
            return id;
        }
        return id.substring(0, offset);
    }

    public static final SMoc convertToICRS(SMoc moc) throws Exception {
        String altsys = moc.getSpaceSys();
        if (altsys.equals("C") || altsys.equalsIgnoreCase("equatorial") || altsys.equalsIgnoreCase("equ")) {
            return moc;
        }
        if (altsys.equalsIgnoreCase("galactic") || altsys.equalsIgnoreCase("gal")) {
            altsys = "G";
        } else if (altsys.equalsIgnoreCase("ecliptic") || altsys.equalsIgnoreCase("ecl")) {
            altsys = "E";
        }
        char a = altsys.charAt(0);
        if (a != 'G' && a != 'E') {
            return null;
        }
        if (moc.getDeepestOrder() > 10 && moc.getCoverage() > 0.99 && !moc.isFull()) {
            moc.setMocOrder(10);
        }
        if (moc.isFull()) {
            moc.setSpaceSys("C");
            return moc;
        }
        Astroframe frameSrc = Astroframe.create(a == 'G' ? "Galactic" : (a == 'E' ? "Ecliptic" : "ICRS"));
        Healpix hpx = new Healpix();
        int order = moc.getDeepestOrder();
        SMoc moc1 = moc.dup();
        moc1.bufferOn();
        long onpix1 = -1L;
        Coo c = new Coo();
        Iterator<Long> it = moc.valIterator();
        while (it.hasNext()) {
            long npix = it.next();
            for (int i = 0; i < 4; ++i) {
                double[] coo = hpx.pix2ang(order + 1, npix * 4L + (long)i);
                c.set(coo[0], coo[1]);
                frameSrc.toICRS(c);
                long npix1 = hpx.ang2pix(order + 1, c.getLon(), c.getLat());
                if (npix1 == onpix1) continue;
                onpix1 = npix1;
                moc1.add(order, npix1 / 4L);
            }
        }
        moc1.bufferOff();
        return moc1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Moc loadMoc(String filename, MyProperties prop) throws Exception {
        Moc moc;
        block15: {
            moc = null;
            FileInputStream fi = null;
            try {
                double[] jdRange;
                fi = new FileInputStream(new File(filename));
                moc = Moc.createMoc(fi);
                if (moc.reduction(0x1400000L)) {
                    ++this.nbReduceMem;
                }
                fi.close();
                fi = null;
                if (moc.isEmpty()) {
                    moc = null;
                }
                moc.seeRangeList().checkConsistency();
                if (!(moc instanceof SMoc)) break block15;
                String sys = ((SMoc)moc).getSpaceSys();
                if (!sys.equals("C")) {
                    long t = System.currentTimeMillis();
                    moc = MultiMoc.convertToICRS((SMoc)moc);
                    if (moc == null) {
                        throw new Exception("Moc coordsys not supported by MocServer");
                    }
                    ++this.nbConvertFromGtoC;
                }
                if ((jdRange = this.getTimeRange(prop)) != null) {
                    STMoc moc1 = new STMoc(41, moc.getSpaceOrder());
                    moc1.add(jdRange[0], jdRange[1], (SMoc)moc);
                    moc = moc1;
                }
            }
            finally {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return moc;
    }

    private double[] getTimeRange(MyProperties prop) {
        if (prop == null) {
            return null;
        }
        double tmin = Double.NaN;
        double tmax = Double.NaN;
        try {
            tmin = Double.parseDouble(prop.get("t_min")) + 2400000.5;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tmax = Double.parseDouble(prop.get("t_max")) + 2400000.5;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Double.isNaN(tmin) && Double.isNaN(tmax)) {
            return null;
        }
        if (tmin > tmax) {
            double x = tmin;
            tmin = tmax;
            tmax = x;
        }
        return new double[]{tmin, tmax};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyProperties loadProp(String propname) throws Exception {
        File f = new File(propname);
        if (!f.exists()) {
            return null;
        }
        InputStreamReader in = null;
        MyProperties prop = null;
        try {
            prop = new MyProperties();
            in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(f)), "UTF8");
            prop.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return prop;
    }

    @Override
    public Iterator<MocItem> iterator() {
        return this.iterator(false);
    }

    public Iterator<MocItem> iterator(boolean flagCopy) {
        if (!flagCopy) {
            return this.map.values().iterator();
        }
        ArrayList<MocItem> list = new ArrayList<MocItem>(this.map.size());
        for (MocItem mi : this.map.values()) {
            list.add(mi);
        }
        return list.iterator();
    }

    public ArrayList<String> scan(int order, long npix) {
        return this.scan(order, npix, null);
    }

    public ArrayList<String> scan(int order, long npix, String mask) {
        boolean match = false;
        if (mask.charAt(0) == '!') {
            match = true;
            mask = mask.substring(1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (MocItem mi : this) {
            if (mask != null && MyProperties.matchMask(mask, mi.mocId) == match) continue;
            try {
                if (mi.moc == null || !mi.moc.getSpaceMoc().isIntersecting(order, npix)) continue;
                res.add(mi.mocId);
            }
            catch (Exception e) {}
        }
        Collections.sort(res);
        return res;
    }

    public ArrayList<String> scan(SMoc moc) {
        return this.scan((Moc)moc, (HashMap<String, String[]>)null, true, -1, 0);
    }

    public static String getID(MyProperties prop) {
        return MultiMoc.getID(prop, null);
    }

    public static String getID(MyProperties prop, String filename) {
        String id = prop.getProperty("ID");
        if (id == null) {
            id = prop.get("creator_did");
            if (id == null) {
                id = prop.get("publisher_did");
            }
            if (id == null) {
                String o = prop.get("obs_id");
                if (o == null && filename != null) {
                    id = "ivo://" + filename.replace("_", "/");
                } else {
                    String p;
                    if (o == null) {
                        o = "id" + System.currentTimeMillis() / 1000L;
                    }
                    if ((p = prop.get("creator_id")) == null) {
                        p = prop.get("publisher_id");
                    }
                    if (p == null) {
                        return null;
                    }
                    id = p + "/" + o;
                }
            }
            if (id.startsWith("ivo://")) {
                id = id.substring(6);
            }
            id = id.replace('?', '/');
        }
        return id;
    }

    private String toDebug(HashMap<String, String[]> mapFilter, String listKey) {
        StringBuilder r = null;
        for (String s : mapFilter.get(listKey)) {
            if (r == null) {
                r = new StringBuilder(listKey + "=" + s);
                continue;
            }
            r.append("," + s);
        }
        return r.toString();
    }

    private boolean match(MocItem mi, HashMap<String, String[]> mapFilter, boolean casesens, boolean andLogic) {
        if (mapFilter == null) {
            return true;
        }
        if (mi.prop == null) {
            return false;
        }
        boolean rep = andLogic;
        for (String listKey : mapFilter.keySet()) {
            boolean internalAndLogic;
            boolean rep1 = false;
            String[] masks = mapFilter.get(listKey);
            boolean bl = internalAndLogic = masks != null && masks.length > 0 && masks[0].startsWith("!");
            if (listKey.indexOf(44) > 0) {
                Tok tok = new Tok(listKey, ",");
                while (tok.hasMoreTokens()) {
                    String key = tok.nextToken();
                    if (andLogic || internalAndLogic || !(rep1 |= this.matchKey(mi, mapFilter, listKey, key, casesens, internalAndLogic))) continue;
                    return true;
                }
            } else {
                rep1 = this.matchKey(mi, mapFilter, listKey, listKey, casesens, internalAndLogic);
            }
            if (!andLogic && !internalAndLogic && rep1) {
                return true;
            }
            if (!andLogic || (rep &= rep1)) continue;
            return false;
        }
        return rep;
    }

    private boolean matchKey(MocItem mi, HashMap<String, String[]> mapFilter, String listKey, String key, boolean casesens, boolean andLogic) {
        if (key.indexOf(63) >= 0 || key.indexOf(42) >= 0) {
            boolean rep = false;
            for (String mask : mapFilter.get(listKey)) {
                rep = false;
                Iterator<String> it = mi.prop.getKeys().iterator();
                while (it.hasNext() && !rep) {
                    String k1 = it.next();
                    if (!MyProperties.matchMask(key, k1)) continue;
                    boolean cs = k1.equals(KEY_ID) ? true : casesens;
                    rep |= this.matchList(mask, mi.prop.get(k1), cs, andLogic);
                }
                if (rep) continue;
                return false;
            }
            if (!rep) {
                return false;
            }
        } else {
            boolean rep;
            if (key.equals(KEY_ID)) {
                casesens = true;
            }
            if (!(rep = this.matchProp(mapFilter.get(listKey), mi.prop.get(key), casesens, andLogic))) {
                return false;
            }
        }
        return true;
    }

    private boolean matchProp(String[] listMask, String vProp, boolean casesens, boolean andLogic) {
        if (vProp == null) {
            return andLogic;
        }
        if (andLogic) {
            for (String mask : listMask) {
                if (this.matchAndList(mask, vProp, casesens)) continue;
                return false;
            }
            return true;
        }
        for (String mask : listMask) {
            if (!this.matchOrList(mask, vProp, casesens)) continue;
            return true;
        }
        return false;
    }

    private boolean matchList(String mask, String vProp, boolean casesens, boolean andLogic) {
        if (andLogic) {
            return this.matchAndList(mask, vProp, casesens);
        }
        return this.matchOrList(mask, vProp, casesens);
    }

    private boolean matchOrList(String mask, String vProp, boolean casesens) {
        if (vProp == null) {
            return false;
        }
        Tok st1 = new Tok(mask, ",");
        while (st1.hasMoreTokens()) {
            String mask1 = st1.nextToken();
            Tok st = new Tok(vProp, "\t");
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                if (!this.match(mask1, v, casesens)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchAndList(String mask, String vProp, boolean casesens) {
        if (vProp == null) {
            return false;
        }
        Tok st1 = new Tok(mask, ",");
        while (st1.hasMoreTokens()) {
            String mask1 = st1.nextToken();
            Tok st = new Tok(vProp, "\t");
            boolean rep = false;
            while (st.hasMoreTokens()) {
                if (!this.match(mask1, st.nextToken(), casesens)) continue;
                rep = true;
                break;
            }
            if (rep) continue;
            return false;
        }
        return true;
    }

    private boolean match(String mask, String value, boolean casesens) {
        int i;
        boolean match = true;
        if (mask.length() == 0) {
            return MyProperties.matchMask(mask, value);
        }
        char c = mask.charAt(0);
        if (c == '>' || c == '<') {
            mask = mask.substring(1);
            boolean strict = true;
            if (mask.startsWith("=")) {
                strict = false;
                mask = mask.substring(1);
            }
            return MyProperties.testInequality(c, strict, mask, value);
        }
        if (mask.charAt(0) == '!') {
            match = false;
            mask = mask.substring(1);
        }
        if ((i = mask.indexOf("..")) > 0) {
            try {
                Double min = Double.parseDouble(mask.substring(0, i).trim());
                Double max = Double.parseDouble(mask.substring(i + 2).trim());
                Double val = Double.parseDouble(value.trim());
                return (min <= val && val <= max) == match;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!casesens) {
            mask = mask.toUpperCase();
            value = value.toUpperCase();
        }
        return MyProperties.matchMask(mask, value) == match;
    }

    public int isUpToDate(String id, long timestamp, boolean flagDiff) {
        MocItem mi = this.getItem(id);
        if (mi == null) {
            return -1;
        }
        if (flagDiff && timestamp != mi.getPropTimeStamp()) {
            return 0;
        }
        if (!flagDiff && timestamp < mi.getPropTimeStamp()) {
            return 0;
        }
        return 1;
    }

    public ArrayList<String> scan(Moc moc, HashMap<String, String[]> mapFilter, boolean casesens, int top, int intersect) {
        ArrayList<String> res = new ArrayList<String>();
        boolean scanTime = moc != null && moc.isTime();
        boolean scanSpace = moc != null && moc.isSpace();
        int n = 0;
        for (MocItem mi : this) {
            if (mapFilter != null && !this.match(mi, mapFilter, casesens, true)) continue;
            if (moc != null) {
                if (mi.moc == null || scanSpace && !mi.moc.isSpace() || scanTime && !mi.moc.isTime()) continue;
                try {
                    if (intersect == 0) {
                        if (!moc.isIntersecting(mi.moc)) {
                        }
                    } else if (intersect == 1) {
                        if (!mi.moc.isIncluding(moc)) {
                        }
                    } else if (!moc.isIncluding(mi.moc)) {
                    }
                }
                catch (Exception e) {}
                continue;
            }
            res.add(mi.mocId);
            if (top == -1 || ++n < top) continue;
            return res;
        }
        Collections.sort(res);
        return res;
    }

    public ArrayList<String> scan(HashMap<String, String[]> mapFilter) {
        return this.scan((Moc)null, mapFilter, true, -1, 0);
    }

    public ArrayList<String> scan(Moc moc, String expr, boolean casesens, int top, int intersect) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        HashSet<String> candidateIds = this.scanExpr(expr, casesens);
        if (candidateIds.size() == 0) {
            return res;
        }
        boolean scanTime = moc != null && moc.isTime();
        boolean scanSpace = moc != null && moc.isSpace();
        int n = 0;
        for (MocItem mi : this) {
            if (!candidateIds.contains(mi.mocId)) continue;
            if (moc != null) {
                if (mi.moc == null || scanSpace && !mi.moc.isSpace() || scanTime && !mi.moc.isTime()) continue;
                try {
                    if (intersect == 0) {
                        if (!moc.isIntersecting(mi.moc)) {
                        }
                    } else if (intersect == 1) {
                        if (!mi.moc.isIncluding(moc)) {
                        }
                    } else if (!moc.isIncluding(mi.moc)) {
                    }
                }
                catch (Exception e) {}
                continue;
            }
            res.add(mi.mocId);
            if (top == -1 || ++n < top) continue;
            return res;
        }
        Collections.sort(res);
        return res;
    }

    public ArrayList<String> scan() {
        ArrayList<String> res = new ArrayList<String>(this.size());
        for (MocItem mi : this) {
            res.add(mi.mocId);
        }
        Collections.sort(res);
        return res;
    }

    public ArrayList<String> scan(String mask) throws Exception {
        return this.scan(mask, true);
    }

    public ArrayList<String> scan(String mask, boolean casesensitive) throws Exception {
        return this.scan((Moc)null, mask, casesensitive, -1, 0);
    }

    private String getExpr(char[] a, int deb, int fin) {
        while (deb < a.length && a[deb] == ' ') {
            ++deb;
        }
        while (fin > 0 && a[fin - 1] == ' ') {
            --fin;
        }
        if (deb < a.length && a[deb] == '(' && fin > 1 && a[fin - 1] == ')') {
            ++deb;
            --fin;
        }
        while (deb < a.length && a[deb] == ' ') {
            ++deb;
        }
        while (fin > 0 && a[fin - 1] == ' ') {
            --fin;
        }
        return new String(a, deb, fin - deb);
    }

    private String getExpr(char[] a, int deb) {
        return this.getExpr(a, deb, a.length);
    }

    private int getOp(Op op, char[] a, int pos) {
        int i;
        MgetOp mode = MgetOp.DEBUT;
        char quote = ' ';
        int par = 0;
        op.terminal = true;
        block8: for (i = pos; i < a.length && mode != MgetOp.FIN; ++i) {
            char c = a[i];
            switch (mode) {
                case DEBUT: {
                    if (Character.isWhitespace(c)) continue block8;
                    if (c == '(') {
                        ++par;
                        op.terminal = false;
                        continue block8;
                    }
                    mode = MgetOp.AVANT;
                    continue block8;
                }
                case DEDANS_PREF: {
                    if (Character.isWhitespace(c)) continue block8;
                    if (c == '\"' || c == '\'') {
                        quote = c;
                        mode = MgetOp.DEDANS_QUOTE;
                        continue block8;
                    }
                    mode = MgetOp.DEDANS;
                    continue block8;
                }
                case DEDANS_QUOTE: {
                    if (c == '\\') {
                        mode = MgetOp.SLASH;
                        continue block8;
                    }
                    if (c != quote) continue block8;
                    mode = MgetOp.DEDANS;
                    continue block8;
                }
                case SLASH: {
                    mode = MgetOp.DEDANS_QUOTE;
                    continue block8;
                }
                case AVANT: {
                    if (c == '=') {
                        mode = MgetOp.DEDANS_PREF;
                        continue block8;
                    }
                }
                case DEDANS: {
                    if (c == ')') {
                        --par;
                    }
                    if (i <= 0 || !(a[i - 1] == '|' && c == '|' || a[i - 1] == '&' && c == '&') && (a[i - 1] != '&' || c != '!')) continue block8;
                    if (par == 0) {
                        mode = MgetOp.FIN;
                        --i;
                        continue block8;
                    }
                    mode = MgetOp.AVANT;
                }
            }
        }
        if (i >= a.length) {
            op.expr = this.getExpr(a, pos);
            op.logic = -1;
            return -1;
        }
        op.expr = this.getExpr(a, pos, i - 1);
        op.logic = a[i] == '!' ? 2 : (a[i] == '|' ? 0 : 1);
        return i + 1;
    }

    private String indent(int niv) {
        StringBuilder s = new StringBuilder();
        for (int j = 0; j < niv * 3; ++j) {
            s.append(' ');
        }
        return s.toString();
    }

    private String adjustExpr(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int pos = (s = this.unQuote(s)).indexOf(33);
        if (pos > 0 && pos < s.length() - 1 && s.charAt(pos + 1) == '=') {
            StringBuilder res = null;
            Tok tok = new Tok(s.substring(pos + 2), ",");
            while (tok.hasMoreTokens()) {
                String val = tok.nextToken();
                if (res == null) {
                    res = new StringBuilder(s.substring(0, pos) + "=!" + val);
                    continue;
                }
                res.append(",!" + val);
            }
            return res.toString();
        }
        int pos1 = s.indexOf(61);
        pos = s.indexOf(62);
        if (pos > 0 && (pos1 == -1 || pos1 > pos)) {
            return s.substring(0, pos) + "=>" + s.substring(pos + 1);
        }
        pos = s.indexOf(60);
        if (pos > 0 && (pos1 == -1 || pos1 > pos)) {
            return s.substring(0, pos) + "=<" + s.substring(pos + 1);
        }
        return s;
    }

    private String unQuote(String s) {
        int i = s.indexOf(61);
        if (i < 0) {
            return s;
        }
        if (s.indexOf(34, i) < 0 && s.indexOf(39) < 0) {
            return s;
        }
        return s.substring(0, i + 1) + Tok.unQuote(s.substring(i + 1));
    }

    private Op calculExpr(int niv, Stack<Op> stack, String s, boolean casesens) throws Exception {
        if (niv > 20) {
            throw new Exception("Expression syntax error");
        }
        char[] a = s.toCharArray();
        int stLimit = stack.size();
        Op op = new Op();
        int pos = this.getOp(op, a, 0);
        if (pos == -1) {
            if (!op.terminal) {
                op = this.calculExpr(niv + 1, stack, op.expr, casesens);
            } else {
                this.initScanItem(op, casesens);
            }
            return op;
        }
        int logic = op.logic;
        op = this.calculExpr(niv + 1, stack, op.expr, casesens);
        op.logic = logic;
        stack.push(op);
        while (pos != -1) {
            op = new Op();
            pos = this.getOp(op, a, pos);
            logic = op.logic;
            op = this.calculExpr(niv + 3, stack, op.expr, casesens);
            op.logic = logic;
            while (stack.size() > stLimit) {
                Op op0 = stack.peek();
                if (op.logic > op0.logic) break;
                op.expr = op0.expr + (op0.logic == 2 ? " &! " : (op0.logic == 1 ? " && " : " || ")) + op.expr;
                op.res = this.combine(op0.res, op.res, op0.logic);
                op.expr = "[" + op.expr + "]";
                op0 = stack.pop();
            }
            if (pos == -1) continue;
            stack.push(op);
        }
        if (stack.size() != stLimit) {
            throw new Exception("Expression error");
        }
        return op;
    }

    private void initScanItem(Op op, boolean casesens) throws Exception {
        op.expr = this.adjustExpr(op.expr);
        int pos = op.expr.indexOf(61);
        String key = pos == -1 ? KEY_ID : op.expr.substring(0, pos).trim();
        String val = op.expr.substring(pos + 1).trim();
        if ((pos == -1 || key.equals(KEY_ID)) && val.indexOf(42) < 0 && val.indexOf(63) < 0 && val.indexOf(44) < 0) {
            op.res = new HashSet(10);
            MocItem mi1 = this.getItem(val);
            if (mi1 != null) {
                op.res.add(mi1.mocId);
            }
            return;
        }
        HashMap<String, String[]> mapFilters = new HashMap<String, String[]>();
        mapFilters.put(key, new String[]{val});
        ArrayList<String> res = this.scan((Moc)null, mapFilters, casesens, -1, 0);
        op.res = new HashSet(Math.max(2 * res.size(), this.size()));
        op.res.addAll(res);
    }

    private HashSet<String> combine(HashSet<String> a, HashSet<String> b, int logic) {
        int aSize = a.size();
        int bSize = b.size();
        if (logic == 0) {
            if (bSize > aSize) {
                b.addAll(a);
                return b;
            }
            a.addAll(b);
            return a;
        }
        if (logic == 1) {
            if (bSize > aSize) {
                b.retainAll(a);
                return b;
            }
            a.retainAll(b);
            return a;
        }
        if (bSize > aSize) {
            b.removeAll(a);
            return b;
        }
        a.removeAll(b);
        return a;
    }

    private HashSet<String> scanExpr(String s, boolean casesens) throws Exception {
        Op op = this.calculExpr(0, new Stack<Op>(), s, casesens);
        return op.res;
    }

    public String getCoordSys() {
        return "C";
    }

    public int getMocOrder() {
        return this.mocOrder;
    }

    public long getBiggestTimeStamp() {
        long t = 0L;
        for (MocItem mi : this) {
            if (mi.dateProp <= t) continue;
            t = mi.dateProp;
        }
        return t;
    }

    public int size() {
        return this.map.size();
    }

    public int size(int typeMoc) {
        int size = 0;
        for (MocItem mi : this) {
            if (mi.moc == null) continue;
            if (typeMoc == 0 && mi.moc instanceof SMoc) {
                ++size;
                continue;
            }
            if (typeMoc == 1 && mi.moc instanceof TMoc) {
                ++size;
                continue;
            }
            if (typeMoc != 2 || !(mi.moc instanceof STMoc)) continue;
            ++size;
        }
        return size;
    }

    public long getMem() {
        long size = 0L;
        for (MocItem mi : this) {
            if (mi.moc == null) continue;
            size += mi.moc.getMem();
        }
        return size += this.getPropMem();
    }

    public long getPropMem() {
        long size = 0L;
        for (MocItem mi : this) {
            if (mi.prop == null) continue;
            size += mi.prop.getMem();
        }
        return size;
    }

    public String toString() {
        return "MultiMoc: hash=" + this.hashCode() + " nbmoc=" + this.size() + " mem=" + this.getMem() / 0x100000L + "MB";
    }

    public static void main(String[] s) {
        try {
            MultiMoc m = new MultiMoc();
            long t0 = System.currentTimeMillis();
            String s3 = "/Users/Pierre/.aladin/Cache/Multiprop.bin";
            m = new BinaryDump().load(s3);
            System.out.println("Multiprop loaded (" + m.size() + " rec.) in " + (System.currentTimeMillis() - t0) + "ms...");
            String s2 = "(ID=ESA* || ID=*arche* || ID=\"toto(titi*\") && (client_application=* || ID=*25*)";
            System.out.println("calculer: " + s2);
            t0 = System.currentTimeMillis();
            ArrayList<String> res = m.scan(s2, false);
            System.out.println("R\u00e9sultat (" + res.size() + " rec.) in " + (System.currentTimeMillis() - t0) + "ms...");
            int i = 0;
            for (String s1 : res) {
                System.out.println("   " + s1);
                if (++i <= 20) continue;
                System.out.println("   ...");
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Reader
    extends Thread {
        ConcurrentLinkedQueue<File> list;
        boolean running;
        MultiMoc oMM;
        HashSet<String> listId;
        boolean flagWithMoc;
        PrintWriter out;
        int nbFiles;
        int nbCreation;
        int nbReused;

        Reader(MultiMoc oMM, boolean flagWithMoc, PrintWriter out, ConcurrentLinkedQueue<File> list, HashSet<String> listId) {
            this.oMM = oMM;
            this.flagWithMoc = flagWithMoc;
            this.out = out;
            this.list = list;
            this.listId = listId;
            this.running = true;
        }

        boolean running() {
            return this.running;
        }

        @Override
        public void run() {
            try {
                MultiMoc.this.reload(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.running = false;
        }
    }

    private static enum MgetOp {
        DEBUT,
        AVANT,
        DEDANS_PREF,
        DEDANS_QUOTE,
        SLASH,
        DEDANS,
        FIN;

    }

    private class Op {
        String expr;
        HashSet<String> res;
        int logic;
        boolean terminal = false;

        private Op() {
        }

        public String toString() {
            return this.expr + (this.logic == 2 ? "&!" : (this.logic == 0 ? "||" : (this.logic == 1 ? "&&" : "")));
        }
    }
}

